/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.common.entity.animal;

import com.teamabnormals.neapolitan.common.entity.goal.ChimpApeModeGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpAttackGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpAvoidEntityGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpBeGroomedGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpCryGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpEatBananaGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpFlipGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpFollowOthersGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpFollowParentGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpGetScaredGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpGrabBananaGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpGroomGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpHurtByTargetGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpJumpOnBouncyGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpLookAtItemGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpOpenBunchGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpPanicGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpPlayNoteBlockGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpPlayWithHelmetGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpRandomWalkingGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpShakeBundleGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpShakeHeadGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpShareBananaGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpSitGoal;
import com.teamabnormals.neapolitan.common.entity.goal.ChimpTemptBananaGoal;
import com.teamabnormals.neapolitan.common.entity.monster.PlantainSpider;
import com.teamabnormals.neapolitan.common.entity.projectile.BananaPeel;
import com.teamabnormals.neapolitan.common.entity.util.ChimpanzeeAction;
import com.teamabnormals.neapolitan.common.entity.util.ChimpanzeeType;
import com.teamabnormals.neapolitan.core.other.NeapolitanConstants;
import com.teamabnormals.neapolitan.core.other.tags.NeapolitanBiomeTags;
import com.teamabnormals.neapolitan.core.other.tags.NeapolitanEntityTypeTags;
import com.teamabnormals.neapolitan.core.other.tags.NeapolitanItemTags;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.teamabnormals.neapolitan.core.registry.NeapolitanEntityTypes;
import com.teamabnormals.neapolitan.core.registry.NeapolitanItems;
import com.teamabnormals.neapolitan.core.registry.NeapolitanParticleTypes;
import com.teamabnormals.neapolitan.core.registry.NeapolitanSoundEvents;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class Chimpanzee
extends Animal
implements NeutralMob {
    private static final EntityDataAccessor<Integer> CHIMPANZEE_TYPE = SynchedEntityData.m_135353_(Chimpanzee.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.m_135353_(Chimpanzee.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> APE_MODE_TIME = SynchedEntityData.m_135353_(Chimpanzee.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HUNGER = SynchedEntityData.m_135353_(Chimpanzee.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DIRTINESS = SynchedEntityData.m_135353_(Chimpanzee.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PALENESS = SynchedEntityData.m_135353_(Chimpanzee.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LEFT_HAND_DYE_COLOR = SynchedEntityData.m_135353_(Chimpanzee.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> RIGHT_HAND_DYE_COLOR = SynchedEntityData.m_135353_(Chimpanzee.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(Chimpanzee.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_LEFT_HAND_DYED = SynchedEntityData.m_135353_(Chimpanzee.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_RIGHT_HAND_DYED = SynchedEntityData.m_135353_(Chimpanzee.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> ACTION = SynchedEntityData.m_135353_(Chimpanzee.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.m_135353_(Chimpanzee.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Direction> FACING = SynchedEntityData.m_135353_(Chimpanzee.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final UUID SPEED_MODIFIER_SITTING_UUID = UUID.fromString("2EF64346-9E56-44E9-9574-1BF9FD6443CF");
    private static final AttributeModifier SPEED_MODIFIER_SITTING = new AttributeModifier(SPEED_MODIFIER_SITTING_UUID, "Sitting speed reduction", -0.75, AttributeModifier.Operation.MULTIPLY_BASE);
    public static final EntityDimensions SITTING_DIMENSIONS = EntityDimensions.m_20395_((float)0.6f, (float)1.0f);
    private static final UniformInt ANGER_RANGE = TimeUtil.m_145020_((int)20, (int)39);
    private UUID lastHurtBy;
    private int attackTimer;
    private int climbingStamina;
    private boolean isLeader;
    private boolean lookingForBundle;
    @Nullable
    private Chimpanzee groomingTarget;
    @Nullable
    private Chimpanzee groomer;
    private float climbAnim;
    private float climbAnimO;
    private float sitAnim;
    private float sitAnimO;
    private int headShakeAnim;
    private int headShakeAnimO;
    private float flipAnim;
    private float flipAnimO;
    public boolean isPartying;
    BlockPos jukeboxPosition;

    public Chimpanzee(EntityType<? extends Animal> type, Level worldIn) {
        super(type, worldIn);
        this.climbingStamina = 20 + this.f_19796_.m_188503_(40);
        this.isPartying = false;
        this.f_21365_ = new LookHelperController();
        this.m_21553_(true);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ChimpSitGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new ChimpGetScaredGoal(this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new ChimpGrabBananaGoal(this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new ChimpAttackGoal(this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new ChimpPanicGoal(this, 1.25));
        this.f_21345_.m_25352_(6, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(7, new ChimpAvoidEntityGoal<PlantainSpider>(this, PlantainSpider.class, 4.0f, 1.0, 1.25));
        this.f_21345_.m_25352_(8, (Goal)new ChimpOpenBunchGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new ChimpEatBananaGoal(this));
        this.f_21345_.m_25352_(10, (Goal)new ChimpTemptBananaGoal(this, 1.25));
        this.f_21345_.m_25352_(11, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_(NeapolitanItemTags.CHIMPANZEE_FOOD), false));
        this.f_21345_.m_25352_(12, (Goal)new ChimpFollowParentGoal(this, 1.25));
        this.f_21345_.m_25352_(13, (Goal)new ChimpShareBananaGoal(this, 1.0));
        this.f_21345_.m_25352_(14, (Goal)new ChimpBeGroomedGoal(this));
        this.f_21345_.m_25352_(15, (Goal)new ChimpGroomGoal(this, 1.0));
        this.f_21345_.m_25352_(16, (Goal)new ChimpFollowOthersGoal(this, 1.0));
        this.f_21345_.m_25352_(17, (Goal)new ChimpShakeBundleGoal(this, 1.0, 48, 16));
        this.f_21345_.m_25352_(18, (Goal)new ChimpPlayWithHelmetGoal(this));
        this.f_21345_.m_25352_(19, (Goal)new ChimpCryGoal(this));
        this.f_21345_.m_25352_(20, (Goal)new ChimpShakeHeadGoal(this));
        this.f_21345_.m_25352_(21, (Goal)new ChimpLookAtItemGoal(this));
        this.f_21345_.m_25352_(22, (Goal)new ChimpJumpOnBouncyGoal(this, 1.0, 16));
        this.f_21345_.m_25352_(23, (Goal)new ChimpPlayNoteBlockGoal(this, 1.0, 16));
        this.f_21345_.m_25352_(24, (Goal)new ChimpFlipGoal(this));
        this.f_21345_.m_25352_(25, (Goal)new ChimpApeModeGoal(this, 1.0));
        this.f_21345_.m_25352_(26, (Goal)new ChimpRandomWalkingGoal(this, 1.0));
        this.f_21345_.m_25352_(27, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(28, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 6.0f));
        this.f_21345_.m_25352_(29, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Chimpanzee)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(1, (Goal)new ChimpHurtByTargetGoal(this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 3.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHIMPANZEE_TYPE, (Object)0);
        this.f_19804_.m_135372_(ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(APE_MODE_TIME, (Object)0);
        this.f_19804_.m_135372_(HUNGER, (Object)0);
        this.f_19804_.m_135372_(DIRTINESS, (Object)0);
        this.f_19804_.m_135372_(PALENESS, (Object)0);
        this.f_19804_.m_135372_(LEFT_HAND_DYE_COLOR, (Object)0);
        this.f_19804_.m_135372_(RIGHT_HAND_DYE_COLOR, (Object)0);
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(IS_LEFT_HAND_DYED, (Object)false);
        this.f_19804_.m_135372_(IS_RIGHT_HAND_DYED, (Object)false);
        this.f_19804_.m_135372_(ACTION, (Object)0);
        this.f_19804_.m_135372_(CLIMBING, (Object)0);
        this.f_19804_.m_135372_(FACING, (Object)Direction.DOWN);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.m_21678_(compound);
        compound.m_128405_("ChimpanzeeType", this.getChimpanzeeType());
        compound.m_128405_("ApeModeTime", this.getApeModeTime());
        compound.m_128405_("Hunger", this.getHunger());
        compound.m_128405_("Dirtiness", this.getDirtiness());
        compound.m_128405_("Paleness", this.getPaleness());
        compound.m_128344_("LeftHandDyeColor", (byte)this.getHandDyeColor(HumanoidArm.LEFT).m_41060_());
        compound.m_128344_("RightHandDyeColor", (byte)this.getHandDyeColor(HumanoidArm.RIGHT).m_41060_());
        compound.m_128379_("Sitting", this.isSitting());
        compound.m_128379_("IsLeftHandDyed", this.getHandDyed(HumanoidArm.LEFT));
        compound.m_128379_("IsRightHandDyed", this.getHandDyed(HumanoidArm.RIGHT));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_147285_(this.m_9236_(), compound);
        this.setChimpanzeeType(compound.m_128451_("ChimpanzeeType"));
        this.setApeModeTime(compound.m_128451_("ApeModeTime"));
        this.setHunger(compound.m_128451_("Hunger"));
        this.setDirtiness(compound.m_128451_("Dirtiness"));
        this.setPaleness(compound.m_128451_("Paleness"));
        this.setHandDyeColor(DyeColor.m_41053_((int)compound.m_128451_("LeftHandDyeColor")), HumanoidArm.LEFT);
        this.setHandDyeColor(DyeColor.m_41053_((int)compound.m_128451_("RightHandDyeColor")), HumanoidArm.RIGHT);
        this.setSitting(compound.m_128471_("Sitting"));
        this.setHandDyed(compound.m_128471_("IsLeftHandDyed"), HumanoidArm.LEFT);
        this.setHandDyed(compound.m_128471_("IsRightHandDyed"), HumanoidArm.RIGHT);
    }

    protected BodyRotationControl m_7560_() {
        return new BodyHelperController();
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WallClimberNavigation((Mob)this, worldIn);
    }

    public int m_8100_() {
        return this.getApeModeTime() > 0 ? 20 : 120;
    }

    protected SoundEvent m_7515_() {
        return this.m_21660_() || this.getApeModeTime() > 0 ? (SoundEvent)NeapolitanSoundEvents.CHIMPANZEE_SCREAM.get() : (SoundEvent)NeapolitanSoundEvents.CHIMPANZEE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)NeapolitanSoundEvents.CHIMPANZEE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)NeapolitanSoundEvents.CHIMPANZEE_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)NeapolitanSoundEvents.CHIMPANZEE_STEP.get(), 0.15f, 1.0f);
    }

    @Nullable
    public SoundEvent m_7866_(ItemStack itemStackIn) {
        return SoundEvents.f_271165_;
    }

    public void playScreamSound() {
        this.m_5496_((SoundEvent)NeapolitanSoundEvents.CHIMPANZEE_SCREAM.get(), this.m_6121_(), this.m_6100_());
    }

    protected float m_6121_() {
        return 0.4f;
    }

    protected void m_8024_() {
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.m_21660_()) {
            this.f_20889_ = this.f_19797_;
        }
        if (this.getApeModeTime() > 0 && this.m_21566_().m_24995_() && !this.isSitting()) {
            double d0 = this.m_21566_().m_24999_();
            this.m_6858_(d0 >= 1.0);
        } else {
            this.m_6858_(false);
        }
        super.m_8024_();
    }

    public boolean m_7327_(Entity entityIn) {
        this.swingArms();
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (int)f > 0 ? f / 2.0f + (float)this.f_19796_.m_188503_((int)f) : f;
        float f2 = this.isChimpanzeeWeapon(this.m_21205_()) || this.isChimpanzeeWeapon(this.m_21206_()) ? f1 + 1.0f : f1;
        boolean flag = entityIn.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f2);
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public boolean isChimpanzeeWeapon(ItemStack stack) {
        Item item = stack.m_41720_();
        return item == Items.f_42398_ || item == Items.f_41911_;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (this.canStandUp()) {
            this.setSitting(false);
        }
        return super.m_6469_(source, amount);
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_ && this.isDoingAction(ChimpanzeeAction.DEFAULT, ChimpanzeeAction.CLIMBING)) {
            this.setDefaultAction();
        }
        super.m_8119_();
        if (this.m_6084_()) {
            if (!this.m_9236_().f_46443_) {
                this.handleClimbing();
                if (this.f_19796_.m_188503_(60) == 0) {
                    this.setLeader(this.shouldBeLeader());
                }
                if (this.f_19796_.m_188503_(100) == 0 && (this.m_20071_() || this.m_9236_().m_46758_(this.m_20183_()))) {
                    this.setHandDyed(false, this.f_19796_.m_188499_() ? HumanoidArm.LEFT : HumanoidArm.RIGHT);
                }
            }
            this.spawnParticles();
        }
        this.climbAnimO = this.climbAnim;
        this.climbAnim = this.isDoingAction(ChimpanzeeAction.CLIMBING) ? Math.min(this.climbAnim + 0.125f, 0.75f) : (this.isDoingAction(ChimpanzeeAction.HANGING, ChimpanzeeAction.SHAKING) ? Math.min(this.climbAnim + 0.125f, 1.0f) : Math.max(this.climbAnim - 0.125f, 0.0f));
        this.sitAnimO = this.sitAnim;
        this.sitAnim = this.isSitting() ? Math.min(this.sitAnim + 0.167f, 1.0f) : Math.max(this.sitAnim - 0.167f, 0.0f);
        this.headShakeAnimO = this.headShakeAnim;
        if (this.headShakeAnim > 0) {
            --this.headShakeAnim;
        }
        this.flipAnimO = this.flipAnim;
        if (this.flipAnim > 0.0f) {
            this.flipAnim -= 1.0f;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.jukeboxPosition == null || !this.jukeboxPosition.m_203195_((Position)this.m_20182_(), 3.46) || this.m_9236_().m_8055_(this.jukeboxPosition).m_60734_() != Blocks.f_50131_) {
            this.isPartying = false;
            this.jukeboxPosition = null;
        }
        this.m_6210_();
        if (!this.m_9236_().f_46443_) {
            if (this.getApeModeTime() > 0) {
                this.setApeModeTime(this.getApeModeTime() - 1);
            }
            if (!this.isHungry() && this.getHunger() >= 0) {
                this.setHunger(this.getHunger() + 1);
                if (this.isHungry()) {
                    this.setLeader(this.shouldBeLeader());
                }
            }
            if (!this.isDirty() && this.getDirtiness() >= 0) {
                this.setDirtiness(this.getDirtiness() + 1);
            }
            if (this.getPaleness() >= 0) {
                if (this.isInSunlight()) {
                    this.setPaleness(this.getPaleness() - 1);
                } else if (!this.needsSunlight()) {
                    this.setPaleness(this.getPaleness() + 1);
                }
            }
            if (this.shouldClimb() && this.f_19863_) {
                if (--this.climbingStamina <= 0) {
                    this.climbingStamina = -20;
                }
            } else if (this.m_20096_()) {
                this.climbingStamina = this.climbingStamina < 0 ? ++this.climbingStamina : 20 + this.f_19796_.m_188503_(40);
            }
        }
    }

    private void spawnParticles() {
        if (this.isDirty() && this.f_19797_ % 6 == 0) {
            double d0 = ((double)this.f_19796_.m_188501_() + 1.0) * 0.06;
            double d1 = (double)this.f_19796_.m_188503_(360) - 360.0;
            double d2 = ((double)this.f_19796_.m_188501_() + 1.0) * 14.0;
            this.m_9236_().m_7106_((ParticleOptions)NeapolitanParticleTypes.FLY.get(), this.m_20208_(0.5), this.m_20188_() + this.f_19796_.m_188500_() * 0.2 + 0.3, this.m_20262_(0.5), d0, d1, d2 *= this.f_19796_.m_188499_() ? 1.0 : -1.0);
        }
        if (this.isDoingAction(ChimpanzeeAction.EATING)) {
            ItemStack food = this.getSnack();
            if (this.f_19797_ % 10 == 0 && !food.m_41619_()) {
                if (this.m_9236_().f_46443_ && food.m_41780_() != UseAnim.DRINK) {
                    for (int i = 0; i < 6; ++i) {
                        Vec3 vector3d = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.f_19796_.m_188501_() - 0.5) * 0.1);
                        vector3d = vector3d.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
                        vector3d = vector3d.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                        double d0 = (double)(-this.f_19796_.m_188501_()) * 0.2;
                        Vec3 vector3d1 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.2, d0, 0.6 * (double)this.m_6134_() + ((double)this.f_19796_.m_188501_() - 0.5) * 0.2);
                        vector3d1 = vector3d1.m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
                        vector3d1 = vector3d1.m_82520_(this.m_20185_(), this.m_20188_(), this.m_20189_());
                        this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_21120_(this.getSnackHand())), vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_, vector3d.f_82479_, vector3d.f_82480_ + 0.05, vector3d.f_82481_);
                    }
                }
                if (food.m_41780_() == UseAnim.DRINK) {
                    this.m_5496_(food.m_41615_(), 0.5f, this.f_19796_.m_188501_() * 0.1f + 0.9f);
                } else {
                    this.m_5496_(food.m_41616_(), 0.5f + 0.5f * (float)this.f_19796_.m_188503_(2), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                }
            }
        } else if (this.isDoingAction(ChimpanzeeAction.CRYING) && this.m_9236_().f_46443_ && this.f_19797_ % 2 == 0 && this.f_19796_.m_188503_(4) > 0) {
            for (int i = 0; i < 2; ++i) {
                double d0 = i == 0 ? (double)this.f_19796_.m_188501_() * 0.15 + 0.1 : (double)(-this.f_19796_.m_188501_()) * 0.15 - 0.1;
                double d1 = (double)this.f_19796_.m_188501_() * 0.1 + 0.15;
                double d2 = i == 0 ? 0.15 : -0.15;
                Vec3 vector3d = new Vec3(d0, Math.random() * 0.2 + 0.1, (double)this.f_19796_.m_188501_() * 0.2 + 0.1);
                vector3d = vector3d.m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
                Vec3 vector3d1 = new Vec3(d2, d1, 0.35);
                vector3d1 = vector3d1.m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
                vector3d1 = vector3d1.m_82520_(this.m_20185_(), this.m_20188_(), this.m_20189_());
                this.m_9236_().m_7106_((ParticleOptions)NeapolitanParticleTypes.TEAR.get(), vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_, vector3d.f_82479_, vector3d.f_82480_ + 0.05, vector3d.f_82481_);
            }
        }
    }

    private void handleClimbing() {
        this.setBesideClimbableBlock(this.f_19862_);
        if (this.isDoingAction(ChimpanzeeAction.CLIMBING)) {
            Direction newfacing = Direction.DOWN;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Vec3 vector3d = this.m_20272_(Vec3.m_82528_((Vec3i)direction.m_122436_()));
                if (!(Math.abs(vector3d.m_82507_(direction.m_122434_())) <= 0.2)) continue;
                newfacing = direction;
                if (direction != this.f_19804_.m_135370_(FACING)) continue;
                break;
            }
            this.setFacing(newfacing);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!(itemstack.m_41619_() || this.m_6898_(itemstack) && !this.isHungry())) {
            if (this.m_21205_().m_41619_() && (this.isSnack(itemstack) || player.m_36341_()) || this.isHungry() && this.isSnack(itemstack) && !this.isSnack(this.m_21205_())) {
                if (!this.m_21205_().m_41619_()) {
                    this.dropItem(this.m_21205_());
                }
                if (this.isSnack(itemstack)) {
                    this.m_21662_();
                }
                ItemStack itemstack1 = itemstack.m_41777_();
                itemstack1.m_41764_(1);
                this.m_21008_(InteractionHand.MAIN_HAND, itemstack1);
                this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
                this.m_142075_(player, InteractionHand.MAIN_HAND, itemstack);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            return InteractionResult.PASS;
        }
        return super.m_6071_(player, hand);
    }

    public void openBunch(InteractionHand hand) {
        if (!this.m_9236_().f_46443_) {
            BananaPeel bananapeel = (BananaPeel)((EntityType)NeapolitanEntityTypes.BANANA_PEEL.get()).m_20615_(this.m_9236_());
            bananapeel.m_7678_(this.m_20185_(), this.m_20188_(), this.m_20189_(), this.m_146908_(), 0.0f);
            bananapeel.m_20334_(this.f_19796_.m_188500_() * 0.4 - 0.2, 0.4, this.f_19796_.m_188500_() * 0.4 - 0.2);
            this.m_9236_().m_7967_((Entity)bananapeel);
            this.m_21008_(hand, new ItemStack((ItemLike)NeapolitanItems.BANANA.get()));
        }
    }

    public void eatSnack() {
        if (!this.getSnack().m_41619_()) {
            if (this.getSnack().m_41720_() == NeapolitanItems.BANANARROW.get()) {
                this.m_5634_(((Item)NeapolitanItems.BANANA.get()).m_41473_().m_38744_());
                this.m_6469_(this.m_269291_().m_269264_(), 0.0f);
                this.m_21008_(this.getSnackHand(), new ItemStack((ItemLike)Items.f_42412_));
            } else if (this.getSnack().m_41720_() == Items.f_42589_) {
                this.getSnack().m_41671_(this.m_9236_(), (LivingEntity)this);
                this.m_21008_(this.getSnackHand(), new ItemStack((ItemLike)Items.f_42590_));
            } else {
                if (this.getSnack().m_41614_()) {
                    this.m_5634_(this.getSnack().m_41720_().m_41473_().m_38744_());
                }
                this.m_21008_(this.getSnackHand(), this.getSnack().m_41671_(this.m_9236_(), (LivingEntity)this));
            }
        }
        this.setHunger(0);
    }

    public void m_267651_(boolean isFlying) {
        super.m_267651_(this.isDoingAction(ChimpanzeeAction.CLIMBING));
    }

    public boolean m_6147_() {
        return this.isDoingAction(ChimpanzeeAction.DEFAULT, ChimpanzeeAction.CLIMBING) && this.isBesideClimbableBlock() && !this.isSitting() && this.climbingStamina > 0;
    }

    public boolean shouldClimb() {
        return !this.m_20096_() && this.m_6147_();
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.f_19804_.m_135370_(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(CLIMBING, (Object)b0);
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.isSitting()) {
            return SITTING_DIMENSIONS.m_20388_(this.m_6134_());
        }
        return super.m_6972_(pose);
    }

    public boolean canStandUp() {
        EntityDimensions entitysize = this.m_6095_().m_20680_();
        float f = entitysize.f_20377_ / 2.0f;
        Vec3 vector3d = new Vec3(this.m_20185_() - (double)f, this.m_20186_(), this.m_20189_() - (double)f);
        Vec3 vector3d1 = new Vec3(this.m_20185_() + (double)f, this.m_20186_() + (double)entitysize.f_20378_, this.m_20189_() + (double)f);
        AABB axisalignedbb = new AABB(vector3d, vector3d1);
        return this.m_9236_().m_45756_((Entity)this, axisalignedbb.m_82406_(1.0E-7));
    }

    public double m_6049_() {
        return this.m_6162_() ? -0.05 : -0.3;
    }

    public boolean m_7066_(ItemStack itemstackIn) {
        EquipmentSlot equipmentslottype = Mob.m_147233_((ItemStack)itemstackIn);
        if (!this.m_6844_(equipmentslottype).m_41619_()) {
            return false;
        }
        return equipmentslottype == EquipmentSlot.MAINHAND && super.m_7066_(itemstackIn);
    }

    public int getApeModeTime() {
        return (Integer)this.f_19804_.m_135370_(APE_MODE_TIME);
    }

    public void setApeModeTime(int time) {
        this.f_19804_.m_135381_(APE_MODE_TIME, (Object)time);
    }

    public boolean m_7252_(ItemStack stack) {
        ItemStack heldstack = this.m_6844_(EquipmentSlot.MAINHAND);
        return heldstack.m_41619_() || this.getItemValue(stack) > this.getItemValue(heldstack);
    }

    private int getItemValue(ItemStack stack) {
        if (this.isSnack(stack)) {
            return this.isHungry() ? 2 : 1;
        }
        if (this.isFavoriteItem(stack)) {
            return 1;
        }
        return 0;
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.m_32055_();
        if (!this.isDoingAction(ChimpanzeeAction.LOOKING_AT_ITEM, ChimpanzeeAction.PLAYING_WITH_ITEM) && this.m_7252_(itemstack)) {
            int i = itemstack.m_41613_();
            if (i > 1) {
                ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), itemstack.m_41620_(i - 1));
                this.m_9236_().m_7967_((Entity)itementity);
            }
            this.dropItem(this.m_21205_());
            this.m_21053_(itemEntity);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41620_(1));
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)itemEntity, itemstack.m_41613_());
            itemEntity.m_146870_();
            if (this.isSnack(itemstack)) {
                this.m_21662_();
            }
        }
    }

    public boolean isFavoriteItem(ItemStack stack) {
        return stack.m_204117_(NeapolitanItemTags.CHIMPANZEE_FAVORITES);
    }

    public void throwHeldItem(InteractionHand hand) {
        ItemStack stack = this.m_21120_(hand);
        if (!stack.m_41619_() && !this.m_9236_().f_46443_) {
            Item item = stack.m_41720_();
            if (item instanceof ArrowItem) {
                ArrowItem arrowItem = (ArrowItem)item;
                List list = this.m_9236_().m_6443_(Entity.class, this.m_20191_().m_82377_(8.0, 4.0, 8.0), entity -> entity.m_6095_().m_204039_(NeapolitanEntityTypeTags.CHIMPANZEE_DART_TARGETS));
                Entity target = null;
                double maxValue = Double.MAX_VALUE;
                for (Entity entity2 : list) {
                    double distance = this.m_20280_(entity2);
                    if (distance > maxValue) continue;
                    maxValue = distance;
                    target = entity2;
                }
                if (target != null) {
                    AbstractArrow arrow = arrowItem.m_6394_(this.m_9236_(), stack, (LivingEntity)this);
                    double d0 = target.m_20188_() - (double)1.1f;
                    double d1 = target.m_20185_() - this.m_20185_();
                    double d2 = d0 - arrow.m_20186_();
                    double d3 = target.m_20189_() - this.m_20189_();
                    float f = Mth.m_14116_((float)((float)(d1 * d1 + d3 * d3))) * 0.2f;
                    this.m_21391_(target, 90.0f, 90.0f);
                    arrow.m_6686_(d1, d2 + (double)f, d3, 1.6f, 6.0f);
                    this.m_5496_(SoundEvents.f_11687_, 1.0f, 0.4f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                    this.m_9236_().m_7967_((Entity)arrow);
                    this.m_21008_(hand, ItemStack.f_41583_);
                    this.swingArms();
                    this.m_9236_().m_7605_((Entity)this, (byte)4);
                }
            } else {
                if (item instanceof DyeItem || ModList.get().isLoaded("environmental") && item == ForgeRegistries.ITEMS.getValue(NeapolitanConstants.MUD_BALL)) {
                    HumanoidArm handside = hand == InteractionHand.MAIN_HAND ? this.m_5737_() : this.m_5737_().m_20828_();
                    this.setHandDyed(true, handside);
                    this.setHandDyeColor(item instanceof DyeItem ? ((DyeItem)item).m_41089_() : DyeColor.BROWN, handside);
                }
                ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_() + this.m_20154_().f_82479_ * 0.2, this.m_20186_() + (double)(this.m_20206_() * 0.625f), this.m_20189_() + this.m_20154_().f_82481_ * 0.2, stack);
                Vec3 vector3d = new Vec3(this.m_20154_().f_82479_ * 0.25, 0.0, this.m_20154_().f_82481_ * 0.25);
                itemEntity.m_20256_(vector3d);
                itemEntity.m_32010_(40);
                itemEntity.m_32052_(this.m_20148_());
                this.m_9236_().m_7967_((Entity)itemEntity);
                this.m_21008_(hand, ItemStack.f_41583_);
                this.swingArms();
                this.m_9236_().m_7605_((Entity)this, (byte)4);
            }
        }
    }

    public void dropItem(ItemStack itemStack) {
        ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20188_() - (double)0.3f, this.m_20189_(), itemStack);
        itementity.m_32010_(40);
        itementity.m_32052_(this.m_20148_());
        this.m_9236_().m_7967_((Entity)itementity);
    }

    public void spawnItemFromBucket(ItemStack itemStack, HumanoidArm hand) {
        Vec3 vector3d = new Vec3(hand == HumanoidArm.LEFT ? 0.35 : -0.35, 0.0, 0.5);
        vector3d = vector3d.m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
        ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_() + vector3d.f_82479_ * (double)this.m_6134_(), this.m_20188_() - (double)0.15f, this.m_20189_() + vector3d.f_82481_ * (double)this.m_6134_(), itemStack);
        itementity.m_20334_(0.0, 0.25, 0.0);
        itementity.m_32010_(40);
        itementity.m_32052_(this.m_20148_());
        this.m_9236_().m_7967_((Entity)itementity);
    }

    public void setOffFirework(ItemStack itemStack, HumanoidArm hand) {
        Vec3 vector3d = new Vec3(hand == HumanoidArm.LEFT ? 0.35 : -0.35, 0.0, 0.5);
        vector3d = vector3d.m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
        FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(this.m_9236_(), (Entity)this, this.m_20185_() + vector3d.f_82479_ * (double)this.m_6134_(), this.m_20188_(), this.m_20189_() + vector3d.f_82481_ * (double)this.m_6134_(), itemStack);
        this.m_9236_().m_7967_((Entity)fireworkrocketentity);
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public void setLeader(boolean isLeaderIn) {
        this.isLeader = isLeaderIn;
    }

    public boolean isLookingForBundle() {
        return this.lookingForBundle;
    }

    public void setLookingForBundle(boolean lookingForBundleIn) {
        this.lookingForBundle = lookingForBundleIn;
        if (lookingForBundleIn) {
            this.setLeader(this.shouldBeLeader());
            Predicate<Chimpanzee> predicate = chimpanzeeentity -> chimpanzeeentity != this && chimpanzeeentity.m_146764_() >= 0;
            List list = this.m_9236_().m_6443_(Chimpanzee.class, this.m_20191_().m_82377_(12.0, 8.0, 12.0), predicate);
            for (Chimpanzee chimpanzeeentity2 : list) {
                chimpanzeeentity2.setLeader(chimpanzeeentity2.shouldBeLeader());
            }
        }
    }

    private boolean shouldBeLeader() {
        Predicate<Chimpanzee> predicate = chimpanzeeentity -> chimpanzeeentity != this && chimpanzeeentity.m_146764_() >= 0;
        List list = this.m_9236_().m_6443_(Chimpanzee.class, this.m_20191_().m_82377_(8.0, 8.0, 8.0), predicate);
        if (list.isEmpty()) {
            return false;
        }
        int chimpamount = list.size() + 1;
        int leaderamount = 0;
        for (Chimpanzee chimpanzeeentity2 : list) {
            if (chimpanzeeentity2.isLeader()) {
                ++leaderamount;
            }
            if (leaderamount * 4 < chimpamount || this.isLookingForBundle() && !chimpanzeeentity2.isLookingForBundle()) continue;
            return false;
        }
        return true;
    }

    public static boolean canChimpanzeeSpawn(EntityType<Chimpanzee> entity, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_45524_(pos, 0) > 8;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setChimpanzeeType(this.getChimpanzeeTypeForPosition((LevelAccessor)worldIn).getId());
        this.setHunger(this.f_19796_.m_188503_(4800));
        this.setDirtiness(this.f_19796_.m_188503_(4800));
        this.populateDefaultEquipmentSlots(difficultyIn);
        return spawnDataIn;
    }

    public ChimpanzeeType getChimpanzeeTypeForPosition(LevelAccessor worldIn) {
        Holder biome = worldIn.m_204166_(this.m_20183_());
        if (biome.m_203656_(NeapolitanBiomeTags.SPAWNS_RAINFOREST_VARIANT_CHIMPANZEES)) {
            return ChimpanzeeType.RAINFOREST;
        }
        if (biome.m_203656_(NeapolitanBiomeTags.SPAWNS_BAMBOO_VARIANT_CHIMPANZEES)) {
            return ChimpanzeeType.BAMBOO;
        }
        return ChimpanzeeType.JUNGLE;
    }

    protected void populateDefaultEquipmentSlots(DifficultyInstance difficultyIn) {
        if (this.f_19796_.m_188501_() < 0.1f) {
            float f = this.f_19796_.m_188501_();
            ItemStack itemstack = f < 0.6f ? (this.m_9236_().m_204166_(this.m_20183_()).m_203656_(NeapolitanBiomeTags.SPAWNS_BAMBOO_VARIANT_CHIMPANZEES) ? new ItemStack((ItemLike)Items.f_41911_) : new ItemStack((ItemLike)Items.f_42398_)) : new ItemStack((ItemLike)NeapolitanBlocks.BANANA_FROND.get());
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack);
        }
    }

    public Chimpanzee getBreedOffspring(ServerLevel world, AgeableMob ageableMob) {
        Chimpanzee baby = (Chimpanzee)((EntityType)NeapolitanEntityTypes.CHIMPANZEE.get()).m_20615_((Level)world);
        if (ageableMob instanceof Chimpanzee) {
            Chimpanzee parent = (Chimpanzee)ageableMob;
            baby.setChimpanzeeType(this.f_19796_.m_188499_() ? this.getChimpanzeeType() : parent.getChimpanzeeType());
            baby.setPaleness((this.getPaleness() + parent.getPaleness()) / 2);
        }
        return baby;
    }

    public int getChimpanzeeType() {
        return (Integer)this.f_19804_.m_135370_(CHIMPANZEE_TYPE);
    }

    public void setChimpanzeeType(int type) {
        this.f_19804_.m_135381_(CHIMPANZEE_TYPE, (Object)type);
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(ANGER_TIME);
    }

    public void m_7870_(int time) {
        this.f_19804_.m_135381_(ANGER_TIME, (Object)time);
    }

    public Chimpanzee getGroomingTarget() {
        return this.groomingTarget;
    }

    public void setGroomingTarget(Chimpanzee target) {
        this.groomingTarget = target;
    }

    public Chimpanzee getGroomer() {
        return this.groomer;
    }

    public void setGroomer(Chimpanzee groomerIn) {
        this.groomer = groomerIn;
    }

    public Direction getFacing() {
        return (Direction)this.f_19804_.m_135370_(FACING);
    }

    public void setFacing(Direction direction) {
        this.f_19804_.m_135381_(FACING, (Object)direction);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public void setSitting(boolean sitting) {
        this.f_19804_.m_135381_(SITTING, (Object)sitting);
        AttributeInstance modifiableattributeinstance = this.m_21051_(Attributes.f_22279_);
        if (modifiableattributeinstance.m_22111_(SPEED_MODIFIER_SITTING_UUID) != null) {
            modifiableattributeinstance.m_22130_(SPEED_MODIFIER_SITTING);
        }
        if (sitting) {
            modifiableattributeinstance.m_22118_(SPEED_MODIFIER_SITTING);
        }
    }

    public DyeColor getHandDyeColor(HumanoidArm handSide) {
        return DyeColor.m_41053_((int)(handSide == HumanoidArm.LEFT ? ((Integer)this.f_19804_.m_135370_(LEFT_HAND_DYE_COLOR)).intValue() : ((Integer)this.f_19804_.m_135370_(RIGHT_HAND_DYE_COLOR)).intValue()));
    }

    public void setHandDyeColor(DyeColor dyeColor, HumanoidArm handSide) {
        this.f_19804_.m_135381_(handSide == HumanoidArm.LEFT ? LEFT_HAND_DYE_COLOR : RIGHT_HAND_DYE_COLOR, (Object)dyeColor.m_41060_());
    }

    public boolean getHandDyed(HumanoidArm handSide) {
        return handSide == HumanoidArm.LEFT ? ((Boolean)this.f_19804_.m_135370_(IS_LEFT_HAND_DYED)).booleanValue() : ((Boolean)this.f_19804_.m_135370_(IS_RIGHT_HAND_DYED)).booleanValue();
    }

    public void setHandDyed(boolean dyed, HumanoidArm handSide) {
        this.f_19804_.m_135381_(handSide == HumanoidArm.LEFT ? IS_LEFT_HAND_DYED : IS_RIGHT_HAND_DYED, (Object)dyed);
    }

    public UUID m_6120_() {
        return this.lastHurtBy;
    }

    public void m_6925_(UUID target) {
        this.lastHurtBy = target;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_RANGE.m_214085_(this.f_19796_));
    }

    public int getHunger() {
        return (Integer)this.f_19804_.m_135370_(HUNGER);
    }

    public void setHunger(int amount) {
        this.f_19804_.m_135381_(HUNGER, (Object)amount);
    }

    public boolean isHungry() {
        return this.getHunger() >= 9600;
    }

    public boolean needsSnack() {
        return this.isHungry() && this.getSnack().m_41619_();
    }

    public InteractionHand getSnackHand() {
        if (!this.getSnack(InteractionHand.MAIN_HAND).m_41619_()) {
            return InteractionHand.MAIN_HAND;
        }
        return InteractionHand.OFF_HAND;
    }

    public ItemStack getSnack() {
        if (!this.getSnack(InteractionHand.MAIN_HAND).m_41619_()) {
            return this.getSnack(InteractionHand.MAIN_HAND);
        }
        if (!this.getSnack(InteractionHand.OFF_HAND).m_41619_()) {
            return this.getSnack(InteractionHand.OFF_HAND);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getSnack(InteractionHand hand) {
        ItemStack snack = this.m_21120_(hand);
        if (this.isSnack(snack)) {
            return snack;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(NeapolitanItemTags.CHIMPANZEE_FOOD);
    }

    public boolean isSnack(ItemStack stack) {
        return stack.m_204117_(NeapolitanItemTags.CHIMPANZEE_SNACKS);
    }

    public int getDirtiness() {
        return (Integer)this.f_19804_.m_135370_(DIRTINESS);
    }

    public void setDirtiness(int amount) {
        this.f_19804_.m_135381_(DIRTINESS, (Object)amount);
    }

    public boolean isDirty() {
        return this.getDirtiness() >= 12000;
    }

    public void getCleaned() {
        this.setDirtiness(0);
        this.setHandDyed(false, HumanoidArm.LEFT);
        this.setHandDyed(false, HumanoidArm.RIGHT);
    }

    public int getPaleness() {
        return (Integer)this.f_19804_.m_135370_(PALENESS);
    }

    public void setPaleness(int amount) {
        this.f_19804_.m_135381_(PALENESS, (Object)amount);
    }

    public boolean needsSunlight() {
        return this.getPaleness() >= 6000;
    }

    public float getVisiblePaleness() {
        return Mth.m_14036_((float)(((float)this.getPaleness() - 4800.0f) / 1200.0f), (float)0.0f, (float)1.0f);
    }

    public boolean isInSunlight() {
        BlockPos blockpos = this.m_20202_() instanceof Boat ? BlockPos.m_274561_((double)this.m_20185_(), (double)Math.round(this.m_20186_()), (double)this.m_20189_()).m_7494_() : BlockPos.m_274561_((double)this.m_20185_(), (double)Math.round(this.m_20186_()), (double)this.m_20189_());
        return this.m_9236_().m_45517_(LightLayer.SKY, blockpos) > 8;
    }

    public ChimpanzeeAction getAction() {
        return ChimpanzeeAction.byId(((Byte)this.f_19804_.m_135370_(ACTION)).byteValue());
    }

    public boolean isDoingAction(ChimpanzeeAction ... actions) {
        for (ChimpanzeeAction action : actions) {
            if (this.getAction() != action) continue;
            return true;
        }
        return false;
    }

    public void setAction(ChimpanzeeAction action) {
        this.f_19804_.m_135381_(ACTION, (Object)((byte)action.getId()));
    }

    public void setDefaultAction() {
        if (!this.m_20159_() && this.shouldClimb()) {
            this.setAction(ChimpanzeeAction.CLIMBING);
        } else {
            this.setAction(ChimpanzeeAction.DEFAULT);
        }
    }

    public boolean isPartying() {
        return this.isPartying;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6818_(BlockPos pos, boolean isPartying) {
        this.jukeboxPosition = pos;
        this.isPartying = isPartying;
    }

    public boolean isMouthOpen() {
        if (this.isDoingAction(ChimpanzeeAction.EATING)) {
            return Math.sin(Math.PI * (double)this.f_19797_ * 0.2) > 0.0;
        }
        if (this.isDoingAction(ChimpanzeeAction.CRYING, ChimpanzeeAction.PLAYING_WITH_ITEM, ChimpanzeeAction.PLAYING_WITH_HELMET, ChimpanzeeAction.JUMPING, ChimpanzeeAction.DRUMMING)) {
            return true;
        }
        return this.getApeModeTime() > 0 || this.m_21660_() || this.isHungry() || this.isPartying();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getClimbingAnim(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.climbAnimO, (float)this.climbAnim);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSitAnim(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.sitAnimO, (float)this.sitAnim);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadShakeAnim(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.headShakeAnimO, (float)this.headShakeAnim);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getFlipAnim(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.flipAnimO, (float)this.flipAnim);
    }

    public void swingArms() {
        this.attackTimer = 10;
    }

    public void shakeHead() {
        this.headShakeAnim = 40;
        this.headShakeAnimO = 40;
    }

    public void doFlip() {
        this.flipAnim = 20.0f;
        this.flipAnimO = 20.0f;
    }

    public void shakeHead(ParticleOptions particleData) {
        this.shakeHead();
        double d0 = this.f_19796_.m_188583_() * 0.02;
        double d1 = this.f_19796_.m_188583_() * 0.02;
        double d2 = this.f_19796_.m_188583_() * 0.02;
        this.m_9236_().m_7106_(particleData, this.m_20185_(), this.m_20227_(1.0), this.m_20189_(), d0, d1, d2);
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.swingArms();
        } else if (id == 6) {
            this.shakeHead((ParticleOptions)NeapolitanParticleTypes.CHIMPANZEE_NEEDS_FRIEND.get());
        } else if (id == 7) {
            this.shakeHead((ParticleOptions)NeapolitanParticleTypes.CHIMPANZEE_NEEDS_SUN.get());
        } else if (id == 8) {
            this.shakeHead((ParticleOptions)NeapolitanParticleTypes.CHIMPANZEE_NEEDS_FOOD.get());
        } else if (id == 9) {
            this.doFlip();
        } else {
            super.m_7822_(id);
        }
    }

    class LookHelperController
    extends LookControl {
        public LookHelperController() {
            super((Mob)Chimpanzee.this);
        }

        public void m_8128_() {
            if (this.m_8106_()) {
                Chimpanzee.this.m_146926_(0.0f);
            }
            if (this.m_186069_()) {
                if (this.m_180896_().isPresent() && this.m_180897_().isPresent()) {
                    Chimpanzee.this.f_20885_ = this.m_24956_(Chimpanzee.this.f_20885_, ((Float)this.m_180896_().get()).floatValue(), this.f_24938_);
                    Chimpanzee.this.m_146926_(this.m_24956_(Chimpanzee.this.m_146909_(), ((Float)this.m_180897_().get()).floatValue(), this.f_24939_));
                }
            } else {
                Chimpanzee.this.f_20885_ = this.m_24956_(Chimpanzee.this.f_20885_, Chimpanzee.this.f_20883_, 10.0f);
            }
            Direction facing = Chimpanzee.this.getFacing();
            if (Chimpanzee.this.isDoingAction(ChimpanzeeAction.CLIMBING) && facing != Direction.DOWN) {
                Chimpanzee.this.f_20885_ = Mth.m_14094_((float)Chimpanzee.this.f_20885_, (float)facing.m_122435_(), (float)Chimpanzee.this.m_8085_());
            } else if (!Chimpanzee.this.m_21573_().m_26571_()) {
                Chimpanzee.this.f_20885_ = Mth.m_14094_((float)Chimpanzee.this.f_20885_, (float)Chimpanzee.this.f_20883_, (float)Chimpanzee.this.m_8085_());
            }
        }
    }

    class BodyHelperController
    extends BodyRotationControl {
        private int bodyRotationTickCounter;
        private Direction prevFacing;

        public BodyHelperController() {
            super((Mob)Chimpanzee.this);
        }

        public void m_8121_() {
            super.m_8121_();
            Direction facing = Chimpanzee.this.getFacing();
            if (facing != this.prevFacing || !Chimpanzee.this.isDoingAction(ChimpanzeeAction.CLIMBING)) {
                this.bodyRotationTickCounter = 10;
            }
            this.prevFacing = facing;
            if (facing != Direction.DOWN && Chimpanzee.this.isDoingAction(ChimpanzeeAction.CLIMBING)) {
                int i = this.bodyRotationTickCounter;
                float f = Mth.m_14036_((float)((float)i / 10.0f), (float)0.0f, (float)1.0f);
                float f1 = 90.0f * f;
                Chimpanzee.this.f_20883_ = Mth.m_14094_((float)Chimpanzee.this.f_20883_, (float)facing.m_122435_(), (float)f1);
                if (this.bodyRotationTickCounter > 0) {
                    --this.bodyRotationTickCounter;
                }
            } else if (facing != Direction.DOWN && Chimpanzee.this.isDoingAction(ChimpanzeeAction.CLIMBING)) {
                int i = this.bodyRotationTickCounter;
                float f = Mth.m_14036_((float)((float)i / 10.0f), (float)0.0f, (float)1.0f);
                float f1 = 90.0f * f;
                Chimpanzee.this.f_20883_ = Mth.m_14094_((float)Chimpanzee.this.f_20883_, (float)facing.m_122435_(), (float)f1);
                if (this.bodyRotationTickCounter > 0) {
                    --this.bodyRotationTickCounter;
                }
            }
        }
    }
}

